﻿$1 FUNCTION [dbo].[fn_CariBakiye] (@cariKodu nvarchar(50),@tarih datetime)
RETURNS float
AS
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
BEGIN 
DECLARE @VAL As Float
SELECT @VAL=
	(ISNULL(SUM(CASE
	WHEN evr_belge_tur in (1,2,10) THEN evr_yekun-isnull(odmhar_tutar,0)--Nakit & Kredi düş bakiyeye hesabına katma
	WHEN evr_belge_tur in (7) THEN evr_yekun
	WHEN evr_belge_tur in (3,5)  THEN (-1)*(evr_yekun-isnull(odmhar_tutar,0))--Nakit & Kredi düş bakiyeye hesabına katma
	WHEN evr_belge_tur in (6)  THEN (-1)*evr_yekun
	ELSE 0
	END),0))
FROM CARI_HESAPLAR
	LEFT OUTER JOIN EVRAK_UST_BILGI ON evr_cari_kod=cari_kodu
	LEFT OUTER JOIN (SELECT
		 odmhar_evrak_rec_id,sum(isnull(odmhar_tutar,0)) as odmhar_tutar
		 FROM EVRAK_ODEME_BILGI 
		 WHERE odmhar_odeme_kod in (SELECT odm_kod FROM ODEME_TIPLERI WHERE odm_tip in (0,1))
		 GROUP BY odmhar_evrak_rec_id
	)R ON R.odmhar_evrak_rec_id=evr_RECno 
WHERE evr_cari_kod=@cariKodu and evr_evrak_tarih<=@tarih--Datetime date olarak convert etme foyler bozulur.
GROUP BY cari_unvan1,cari_unvan2
IF @VAL is NULL SET @VAL=0
RETURN ROUND(@VAL,8)
END
