﻿$1   FUNCTION [dbo].[fn_KasaGirisCikis](@kasaNo varchar(25),@tarih datetime)
RETURNS @kasaBakiye TABLE (giris float,cikis float)
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
BEGIN
INSERT INTO @kasaBakiye(giris,cikis)
SELECT
	ISNULL(SUM(CASE WHEN evr_belge_tur in (1,2,10,6) THEN odmhar_tutar  ELSE 0 END),0) AS [Giris],
	ISNULL(SUM(CASE WHEN evr_belge_tur in (3,5,7) THEN odmhar_tutar ELSE 0 END ),0) AS [Cikis]
FROM KASA_TANIMLARI
	LEFT OUTER JOIN EVRAK_UST_BILGI ON evr_kasa_no=ksa_no
	INNER JOIN (SELECT
		 odmhar_evrak_rec_id,sum(isnull(odmhar_tutar,0)) as odmhar_tutar
		 FROM EVRAK_ODEME_BILGI 
		 WHERE odmhar_odeme_kod in (SELECT odm_kod FROM ODEME_TIPLERI WHERE odm_tip in (0))  
		 GROUP BY odmhar_evrak_rec_id
	)R ON R.odmhar_evrak_rec_id=evr_RECno 
WHERE 
	evr_kasa_no=@kasaNo and evr_evrak_tarih<=@tarih--Datetime formatı date olarak convert etme foyler bozulur.
RETURN
END