﻿$1  PROCEDURE [dbo].[CARI_BAKIYE_DURUM]
--@cari_kod StringList READONLY,
@baslangic_tarih dateTime,
@bitis_tarih datetime,
@cari_kod_liste StringList READONLY
AS
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
SELECT 
		cari_kodu AS CariKod,
		ISNULL(cari_unvan1 ,'') AS CariUnvan1,
		ISNULL(cari_unvan2 ,'') AS CariUnvan2,
		borc as Borc,
		alacak as Alacak,
		CASE WHEN borc-alacak>0 THEN borc-alacak ELSE 0 END AS BorcBakiye,
		CASE WHEN alacak-borc>0 THEN alacak-borc ELSE 0 END AS AlacakBakiye
FROM
(SELECT 
	cari_kodu,
	cari_unvan1,
	cari_unvan2,
	ISNULL(SUM(CASE
	WHEN evr_belge_tur in (1,2,10) THEN evr_yekun-isnull(odmhar_tutar,0) --Nakit & Kredi düş bakiyeye hesabına katma
	WHEN evr_belge_tur in (7) THEN evr_yekun
	ELSE 0
	END),0) AS borc,
	ISNULL(SUM(CASE
	 WHEN evr_belge_tur in (3,5) THEN evr_yekun-isnull(odmhar_tutar,0)--Nakit & Kredi düş bakiyeye hesabına katma
	 WHEN evr_belge_tur in (6) THEN evr_yekun 
	 ELSE 0 
	 END ),0)  AS alacak
FROM CARI_HESAPLAR WITH(NOLOCK)
	LEFT OUTER JOIN EVRAK_UST_BILGI WITH(NOLOCK) ON evr_cari_kod=cari_kodu
	LEFT OUTER JOIN (SELECT
		 odmhar_evrak_rec_id,sum(isnull(odmhar_tutar,0)) as odmhar_tutar
		 FROM EVRAK_ODEME_BILGI WITH(NOLOCK)
		 WHERE odmhar_odeme_kod in (SELECT odm_kod FROM ODEME_TIPLERI WITH(NOLOCK) WHERE odm_tip in (0,1))
		 GROUP BY odmhar_evrak_rec_id
	)R ON R.odmhar_evrak_rec_id=evr_RECno 
WHERE  CONVERT(DATE,@baslangic_tarih)<=CONVERT(DATE,evr_evrak_tarih) and CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@bitis_tarih)
AND (cari_kodu in (SELECT Item FROM @cari_kod_liste) OR (select Count(Item) from @cari_kod_liste)<=0)
GROUP BY cari_kodu,cari_unvan1,cari_unvan2)CARI_DURUM 