﻿$1      PROCEDURE [dbo].[CARI_HAREKET_FOY]
@baslangic_tarih dateTime,
@bitis_tarih datetime,
@kod varchar(50)
AS
(SELECT
evr_GuidNo,
evr_evrak_tarih as [Tarih],
evr_belge_no_seri as [Seri],
evr_belge_no_sira as [Sıra],
dbo.fn_EvrakIsmi(evr_belge_tur) as[Evrak Tipi],
evr_aciklama as [Açıklama],
ISNULL(odm_aciklama,CASE WHEN evr_belge_tur in (1,2,10) THEN 'ÖDENE ALINMADI'
						 WHEN evr_belge_tur  in (3,5) THEN 'ÖDEME YAPILMADI' ELSE '-' END) as [Ödeme Tipi],
ISNULL(CASE WHEN evr_belge_tur in (1,2,10) THEN evr_yekun-isnull((CASE WHEN odm_tip in (0,1) THEN isnull(odmhar_tutar,0) ELSE 0 END),0)
					WHEN evr_belge_tur in (7) THEN evr_yekun ELSE 0 END,0) AS [Borc],
ISNULL(CASE WHEN evr_belge_tur in (3,5) THEN evr_yekun-isnull((CASE WHEN odm_tip in (0,1) THEN isnull(odmhar_tutar,0) ELSE 0 END),0)
					WHEN evr_belge_tur in (6) THEN evr_yekun  ELSE 0 END,0) AS [Alacak],
dbo.fn_CariBakiye(@kod,evr_evrak_tarih) AS [Bakiye],
evr_toplam [Toplam],
evr_vergi_tutar [Vergi],
evr_yekun as [Yekun]
FROM EVRAK_UST_BILGI
LEFT OUTER JOIN EVRAK_ODEME_BILGI WITH(NOLOCK) ON evr_RECno=odmhar_evrak_rec_id
LEFT OUTER JOIN ODEME_TIPLERI WITH(NOLOCK) ON odm_kod=odmhar_odeme_kod and odm_magazano=evr_magaza_kod and odm_kasa_no=evr_kasa_no
WHERE evr_cari_kod=@kod and evr_cari_kod!='' AND
CONVERT(DATE,@baslangic_tarih)<=CONVERT(DATE,evr_evrak_tarih) and CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@bitis_tarih) 
UNION ALL
(
SELECT
NEWID() as evr_GuidNo,
@baslangic_tarih as [Tarih],
'' as [Seri],
0 as [Sıra],
'DEVIR' as[Evrak Tipi],
'' as [Açıklama],
'' as [Ödeme Tipi],
(SELECT TOP 1 borc FROM dbo.fn_CariBorcAlacak(evr_cari_kod,@baslangic_tarih)) as [Borç],
(SELECT TOP 1 alacak FROM dbo.fn_CariBorcAlacak(evr_cari_kod,@baslangic_tarih)) as [Alacak],
dbo.fn_CariBakiye(@kod,@baslangic_tarih) AS [Bakiye],
sum(evr_toplam) [Toplam],
sum(evr_vergi_tutar) [Vergi],
sum(evr_yekun) as [Yekun]
FROM EVRAK_UST_BILGI WITH(NOLOCK)
WHERE evr_cari_kod=@kod AND evr_cari_kod!='' AND CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@baslangic_tarih) 
GROUP BY evr_cari_kod
))
ORDER BY [Tarih]