﻿$1  PROCEDURE [dbo].[EVRAK_DETALI_SATIS]
@aktif_kullanici varchar(25)='',
@baslangic_tarih dateTime,
@bitis_tarih datetime
AS 
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
SELECT
*,
T.[FisMiktar]+T.[FaturaMiktar]-T.[IadeMiktar] as NetMiktar,
T.[FisTutar]+T.[FaturaTutar]-T.[IadeTutar] as NetTutar
FROM
(SELECT 
	mgz_kod MagazaKod,
	mgz_isim MagazaIsim,
	SUM(CASE WHEN evr_belge_tur =1 THEN har_miktar ELSE 0 END) as FisMiktar,
	SUM(CASE WHEN evr_belge_tur =2 THEN har_miktar ELSE 0 END) as FaturaMiktar,
	SUM(CASE WHEN evr_belge_tur =3 THEN har_miktar ELSE 0 END) as IadeMiktar,
	SUM(CASE WHEN evr_belge_tur =1 THEN ROUND(har_yekun,2) ELSE 0 END) as FisTutar,
	SUM(CASE WHEN evr_belge_tur =2 THEN ROUND(har_yekun,2) ELSE 0 END) as FaturaTutar,
	SUM(CASE WHEN evr_belge_tur =3 THEN ROUND(har_yekun,2) ELSE 0 END) as IadeTutar
FROM EVRAK_UST_BILGI WITH(NOLOCK)
LEFT OUTER JOIN EVRAK_HAREKET_BILGI WITH(NOLOCK) ON evr_RECno=har_evrak_rec_id and har_Satir_tip=0
LEFT OUTER JOIN MAGAZA_TANIMLARI WITH(NOLOCK) on mgz_kod=evr_magaza_kod
WHERE  CONVERT(DATE,@baslangic_tarih)<=CONVERT(DATE,evr_evrak_tarih) and CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@bitis_tarih) 
AND evr_belge_tur in (1,2,3) 
AND (evr_magaza_kod=dbo.fn_AktifKullaniciMagazaGetir(@aktif_kullanici) OR @aktif_kullanici=0)
GROUP BY mgz_kod,mgz_isim)T