﻿$1  PROCEDURE [dbo].[EVRAK_DETAYLI_MAGAZA_RAPORU]
@aktif_kullanici varchar(25)='',
@magaza_no varchar(25),
@baslangic_tarih dateTime,
@bitis_tarih datetime
AS
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
BEGIN
SELECT
CAST(evr_fis_no AS varchar(25)) as FisNumarasi,
dbo.fn_EvrakIsmi(evr_belge_tur) as EvrakTip,
ROUND(evr_toplam,2)  as EvrakToplam,
evr_toplam_inidirim_tutar as IndirimTutar,
ROUND(evr_vergi_tutar,2) as VergiTutar,
ROUND(evr_yekun,2) as Yekun,
(SELECT TOP 1 COUNT(har_RECno) FROM EVRAK_HAREKET_BILGI WITH(NOLOCK) WHERE evr_RECno=har_evrak_rec_id) as Miktar
FROM EVRAK_UST_BILGI WITH(NOLOCK)
WHERE evr_magaza_kod=@magaza_no 
AND CONVERT(DATE,@baslangic_tarih)<=CONVERT(DATE,evr_evrak_tarih) and CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@bitis_tarih)
AND (evr_magaza_kod=dbo.fn_AktifKullaniciMagazaGetir(@aktif_kullanici) OR @aktif_kullanici=0)
END