﻿$1 PROCEDURE [dbo].[EVRAK_LISTE]
@baslangic_tarih datetime,
@bitis_tarih datetime,
@entegreDb varchar(50),
@entegreKullanim int
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
AS 
DECLARE @sorgu AS NVARCHAR(MAX)='',
@_baslangic_tarih varchar(25),
@_bitis_tarih varchar(25)
set @_baslangic_tarih=@baslangic_tarih
set @_bitis_tarih=@bitis_tarih
 
IF(@entegreKullanim=1)
BEGIN
SET @sorgu=' SELECT
	evr_GuidNo as EvrakGuid,
	mgz_isim as [Mağaza],
	ksa_isim as [Kasa],
	kln_isim as [Kasiyer],
	evr_belge_no_seri as [Evrak Seri],
	evr_belge_no_sira as [Evrak No],
	dbo.fn_EvrakIsmi(evr_belge_tur) as [Evrak Tipi], 
	evr_evrak_tarih as [Tarih],
	CONVERT(VARCHAR(8),evr_evrak_tarih,108) as [Saat],
	cari_unvan1 as [Cari] ,
	ROUND(evr_vergi_tutar,2) as [Toplam KDV],
	ROUND(evr_yekun,2) as [Yekün],
	--ROUND(((evr_yekun-sum('+@entegreDb+'.dbo.fn_FastSell_v2_StokMaliyet(har_barkod,evr_magaza_kod,GETDATE())*har_miktar))/evr_yekun)*100,2) [Evrak Kar Oranı],
	CASE WHEN evr_arkaofis_aktarildimi=1 THEN ''Aktarıldı''
	ELSE ''Aktarılmadı'' END as [Aktarım]
FROM EVRAK_UST_BILGI WITH(NOLOCK)
LEFT OUTER JOIN EVRAK_HAREKET_BILGI WITH(NOLOCK) ON har_evrak_rec_id=evr_RECno
LEFT OUTER JOIN MAGAZA_TANIMLARI  WITH(NOLOCK) ON mgz_kod=evr_magaza_kod
LEFT OUTER JOIN CARI_HESAPLAR WITH(NOLOCK) ON cari_kodu=evr_cari_kod
LEFT OUTER JOIN KULLANICILAR WITH(NOLOCK) ON kln_no=evr_kasiyer_no
LEFT OUTER JOIN KASA_TANIMLARI WITH(NOLOCK) ON ksa_no=evr_kasa_no
WHERE cast(evr_evrak_tarih as date) BETWEEN '''+@_baslangic_tarih +''' AND '''+ @_bitis_tarih+'''
AND evr_belge_tur in (1,2,3,5,9,10)
GROUP BY evr_GuidNo,mgz_kod,mgz_isim,evr_kasiyer_no,ksa_isim,kln_isim,
evr_belge_no_seri,evr_belge_no_sira,evr_belge_tur,evr_evrak_tarih,cari_kodu,cari_unvan1,evr_vergi_tutar,evr_yekun,evr_arkaofis_aktarildimi
ORDER BY evr_evrak_tarih'
END
ELSE
BEGIN
SET @sorgu=' SELECT
	evr_GuidNo as EvrakGuid,
	mgz_isim as [Mağaza],
	ksa_isim as [Kasa],
	kln_isim as [Kasiyer],
	evr_belge_no_seri as [Evrak Seri],
	evr_belge_no_sira as [Evrak No],
	dbo.fn_EvrakIsmi(evr_belge_tur) as [Evrak Tipi], 
	evr_evrak_tarih as [Tarih],
	CONVERT(VARCHAR(8),evr_evrak_tarih,108) as [Saat],
	cari_unvan1 as [Cari] ,
	ROUND(evr_vergi_tutar,2) as [Toplam KDV],
	ROUND(evr_yekun,2) as [Yekün],
	--ROUND(((evr_yekun-sum(dbo.fn_StokMaliyet('''',har_barkod,evr_magaza_kod,GETDATE(),1)*har_miktar))/evr_yekun)*100,2) [Evrak Kar Oranı],
	CASE WHEN evr_arkaofis_aktarildimi=1 THEN ''Aktarıldı''
	ELSE ''Aktarılmadı'' END as [Aktarım]
FROM EVRAK_UST_BILGI WITH(NOLOCK)
LEFT OUTER JOIN EVRAK_HAREKET_BILGI WITH(NOLOCK) ON har_evrak_rec_id=evr_RECno
LEFT OUTER JOIN MAGAZA_TANIMLARI WITH(NOLOCK) ON mgz_kod=evr_magaza_kod
LEFT OUTER JOIN CARI_HESAPLAR WITH(NOLOCK) ON cari_kodu=evr_cari_kod
LEFT OUTER JOIN KULLANICILAR WITH(NOLOCK) ON kln_no=evr_kasiyer_no
LEFT OUTER JOIN KASA_TANIMLARI WITH(NOLOCK) ON ksa_no=evr_kasa_no
WHERE cast(evr_evrak_tarih as date) BETWEEN '''+@_baslangic_tarih +''' AND '''+ @_bitis_tarih+'''
AND evr_belge_tur in (1,2,3,5,9,10)
GROUP BY evr_GuidNo,mgz_kod,mgz_isim,evr_kasiyer_no,ksa_isim,kln_isim,
evr_belge_no_seri,evr_belge_no_sira,evr_belge_tur,evr_evrak_tarih,cari_kodu,cari_unvan1,evr_vergi_tutar,evr_yekun,evr_arkaofis_aktarildimi
ORDER BY evr_evrak_tarih'
END
exec(@sorgu)


