﻿$1  PROCEDURE [dbo].[KASA_ODEME_TIP_DETAYLI_SATIS]
@aktif_kullanici varchar(25)='',
@kasa_no_liste StringList READONLY,
@baslangic_tarih dateTime,
@bitis_tarih datetime
AS
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
SELECT
*,
ROUND(T.[NakitSatis] -T.[IadeNakit],2) AS NetNakitTutar,
ROUND(T.[KrediKartiSatis] -T.[IadeKrediKarti],2) NetKrediTutar,
ROUND(T.[AcikHesapSatis]-T.[IadeAcikHesap],2) AcikHesapNetTutar,
ROUND(T.[SadakatKartSatis]-T.[IadeSadakatKart],2) SadakatKartNetTutar
FROM
(SELECT
	evr_kasa_no KasaNo,
	(SELECT ksa_isim FROM KASA_TANIMLARI WITH(NOLOCK) WHERE ksa_no=evr_kasa_no) as KasaAdi,
	SUM(CASE WHEN odm_tip=0 and evr_belge_tur in (1,2) THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS NakitSatis,
	SUM(CASE WHEN odm_tip=1 and evr_belge_tur in (1,2) THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS KrediKartiSatis,
	SUM(CASE WHEN odm_tip=2 and evr_belge_tur in (1,2) THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS AcikHesapSatis,
	SUM(CASE WHEN odm_tip=4 and evr_belge_tur in (1,2) THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS SadakatKartSatis,
	SUM(CASE WHEN odm_tip=0 and evr_belge_tur=3 THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS IadeNakit,
	SUM(CASE WHEN odm_tip=1 and evr_belge_tur=3 THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS IadeKrediKarti,
	SUM(CASE WHEN odm_tip=2 and evr_belge_tur=3 THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS IadeAcikHesap,
	SUM(CASE WHEN odm_tip=4 and evr_belge_tur=3 THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS IadeSadakatKart
	FROM EVRAK_UST_BILGI  WITH(NOLOCK)
	LEFT OUTER JOIN  EVRAK_ODEME_BILGI WITH(NOLOCK) ON odmhar_evrak_rec_id=evr_RECno
	LEFT OUTER JOIN  ODEME_TIPLERI WITH(NOLOCK) ON odm_kod=odmhar_odeme_kod and evr_magaza_kod=odm_magazano and odm_kasa_no=evr_kasa_no
	WHERE (((select COUNT(Item) from @kasa_no_liste)>0 AND evr_kasa_no IN (select Item from @kasa_no_liste)) OR (select Count(Item) from @kasa_no_liste)<=0) AND  
	  CONVERT(DATE,@baslangic_tarih)<=CONVERT(DATE,evr_evrak_tarih) and CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@bitis_tarih)
	AND evr_belge_tur in (1,2,3)
	AND (evr_magaza_kod=dbo.fn_AktifKullaniciMagazaGetir(@aktif_kullanici) OR @aktif_kullanici=0)
	GROUP BY evr_kasa_no)T