﻿$1 PROCEDURE [dbo].[KASIYER_HAREKET_FOY]
@baslangic_tarih dateTime,
@bitis_tarih datetime,
@kod varchar(50)
AS
(SELECT
evr_GuidNo,
evr_evrak_tarih as [Tarih],
evr_belge_no_seri as [Seri],
evr_belge_no_sira as [Sıra],
dbo.fn_EvrakIsmi(evr_belge_tur) [Evrak Tipi],
isnull(cari_unvan1,'')+' '+isnull(cari_unvan2,'') as [Cari],
ksa_isim as [Kasa],
dbo.fn_KullaniciIsim(evr_plasiyer_no) as [Plasiyer],
ROUND(evr_yekun,2) as [Yekün]
FROM EVRAK_UST_BILGI WITH(NOLOCK)
LEFT OUTER JOIN MAGAZA_TANIMLARI WITH(NOLOCK) ON mgz_kod=evr_magaza_kod
LEFT OUTER JOIN CARI_HESAPLAR WITH(NOLOCK) ON cari_kodu=evr_cari_kod
LEFT OUTER JOIN KASA_TANIMLARI WITH(NOLOCK) ON ksa_no=evr_kasa_no
WHERE evr_kasiyer_no=@kod and
CONVERT(DATE,@baslangic_tarih)<=CONVERT(DATE,evr_evrak_tarih) and CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@bitis_tarih) 
UNION ALL
(
SELECT
NEWID() as evr_GuidNo,
@baslangic_tarih as [Tarih],
'' as [Seri],
0 as [Sıra],
'DEVIR' as [Evrak Tipi],
'' as [Cari],
'' as [Kasiyer],
'' as [Plasiyer],
sum(evr_yekun) as [Yekün]
FROM EVRAK_UST_BILGI WITH(NOLOCK)
WHERE evr_kasiyer_no=@kod AND CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@baslangic_tarih)
GROUP BY evr_kasiyer_no
)
UNION ALL
(
SELECT
NEWID() as evr_GuidNo,
khar_tarih as [Tarih],
'' as [Seri],
0 as [Sıra],
dbo.fn_KasaHareketEvrakIsmi(khar_tip) as [Evrak Tipi],
'' as [Cari],
dbo.fn_KullaniciIsim(khar_kasiyer_no) as [Kasiyer],
'' as [Plasiyer],
khar_tutar as [Yekün]
FROM KASA_HAREKET_BILGI WITH(NOLOCK)
where khar_kasiyer_no=@kod and CONVERT(DATE,@baslangic_tarih)<=CONVERT(DATE,khar_tarih) and CONVERT(DATE,khar_tarih)<=CONVERT(DATE,@bitis_tarih) 
))
ORDER BY [Tarih]