﻿$1 PROCEDURE [dbo].[MAGAZA_ODEME_TIP_DETAYLI_SATIS]
@aktif_kullanici varchar(25)='',
@magaza_no_liste StringList READONLY,
@baslangic_tarih dateTime,
@bitis_tarih datetime
AS
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
SELECT
*,
ROUND(T.[Nakit Satış] -T.[Iade Nakit],2) AS [Net Nakit Tutar],
ROUND(T.[Kredi Kartı Satış] -T.[Iade Kredi Kartı],2) [Net Kredi Tutar],
ROUND(T.[Açık Hesap Satış]-T.[Iade Açık Hesap],2) [Açık Hesap Net Tutar],
ROUND(T.[SadakatKartSatis]-T.[IadeSadakatKart],2) SadakatKartNetTutar
FROM
(SELECT
	evr_magaza_kod [Mağaza Kod],
	(SELECT mgz_isim FROM MAGAZA_TANIMLARI WITH(NOLOCK) WHERE mgz_kod=evr_magaza_kod) as [Mağaza Adı],
	SUM(CASE WHEN odm_tip=0 and evr_belge_tur in (1,2) THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS [Nakit Satış],
	SUM(CASE WHEN odm_tip=1 and evr_belge_tur in (1,2) THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS [Kredi Kartı Satış],
	SUM(CASE WHEN odm_tip=2 and evr_belge_tur in (1,2) THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS [Açık Hesap Satış],
	SUM(CASE WHEN odm_tip=4 and evr_belge_tur in (1,2) THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS SadakatKartSatis,
	SUM(CASE WHEN odm_tip=0 and evr_belge_tur=3 THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS [Iade Nakit],
	SUM(CASE WHEN odm_tip=1 and evr_belge_tur=3 THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS [Iade Kredi Kartı],
	SUM(CASE WHEN odm_tip=2 and evr_belge_tur=3 THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS [Iade Açık Hesap],
	SUM(CASE WHEN odm_tip=4 and evr_belge_tur=3 THEN ROUND(odmhar_tutar,2) ELSE 0 END) AS IadeSadakatKart
	FROM EVRAK_UST_BILGI  WITH(NOLOCK)
	LEFT OUTER JOIN  EVRAK_ODEME_BILGI WITH(NOLOCK) ON odmhar_evrak_rec_id=evr_RECno
	LEFT OUTER JOIN  ODEME_TIPLERI WITH(NOLOCK) ON odm_kod=odmhar_odeme_kod and evr_magaza_kod=odm_magazano and odm_kasa_no=evr_kasa_no
	WHERE (((select COUNT(Item) from @magaza_no_liste)>0 AND evr_magaza_kod IN (select Item from @magaza_no_liste)) OR (select Count(Item) from @magaza_no_liste)<=0) AND  
	CONVERT(DATE,@baslangic_tarih)<=CONVERT(DATE,evr_evrak_tarih) and CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@bitis_tarih) 
	AND evr_belge_tur in (1,2,3)
	AND (evr_magaza_kod=dbo.fn_AktifKullaniciMagazaGetir(@aktif_kullanici) OR @aktif_kullanici=0)
	GROUP BY evr_magaza_kod)T