﻿$1    PROCEDURE [dbo].[MAGAZA_SATIS]
@aktif_kullanici varchar(25)='',
@magaza_no StringList READONLY,
@baslangic_tarih dateTime,
@bitis_tarih dateTime
AS
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
SELECT
*,
ROUND(T.SatisMiktar-T.IadeMiktar,2) AS NetMiktar,
ROUND(T.SatisTutar-T.IadeTutar,2) AS NetTutar
FROM
(SELECT 
	mgz_kod MagazaKod,
	mgz_isim MagazaIsim,
	SUM(CASE WHEN evr_belge_tur =3 THEN har_miktar ELSE 0 END) as IadeMiktar,
	SUM(CASE WHEN evr_belge_tur =3 THEN ROUND(har_yekun,2) ELSE 0 END) as IadeTutar,
	SUM(CASE WHEN evr_belge_tur in (1,2) THEN har_miktar ELSE 0 END) as SatisMiktar,
	SUM(CASE WHEN evr_belge_tur in (1,2) THEN ROUND(har_yekun,2) ELSE 0 END) as SatisTutar
FROM EVRAK_UST_BILGI WITH(NOLOCK)
LEFT OUTER JOIN MAGAZA_TANIMLARI WITH(NOLOCK) ON mgz_kod=evr_magaza_kod
LEFT OUTER JOIN EVRAK_HAREKET_BILGI WITH(NOLOCK) ON evr_RECno=har_evrak_rec_id and har_Satir_tip=0
WHERE  evr_belge_tur in (1,2,3) AND (((select COUNT(Item) from @magaza_no)>0 AND evr_magaza_kod IN (select Item from @magaza_no)) OR (select Count(Item) from @magaza_no)<=0) AND  
		CONVERT(DATE,@baslangic_tarih)<=CONVERT(DATE,evr_evrak_tarih) and CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@bitis_tarih) 
		AND (evr_magaza_kod=dbo.fn_AktifKullaniciMagazaGetir(@aktif_kullanici) OR @aktif_kullanici=0)
group by evr_magaza_kod,mgz_isim,mgz_kod,mgz_magaza_evrak_cinsi)T
