﻿$1     PROCEDURE [dbo].[SATIS_KARLILIK]
@aktif_kullanici varchar(25)='',
@baslangic_tarih dateTime,
@bitis_tarih datetime,
@magaza_no varchar(25),
@anagrup_kod_liste StringList READONLY,
@altgrup_kod_liste StringList READONLY,
@reyon_kod_liste StringList READONLY,
@stok_kod_liste StringList READONLY,
@maliyet_vergi_dahil bit
AS
SELECT
	T.[StokKod],
	T.[StokIsim],
	T.[SatisMiktar],
	T.[SatisMiktar]*dbo.fn_StokMaliyet(T.[StokKod],'',@magaza_no,GETDATE(),@maliyet_vergi_dahil) AS [SatisMaliyet],
	T.[SatisTutar] AS [ToplamSatisTutar],
	ROUND(((T.[SatisTutar]-(T.[SatisMiktar]*dbo.fn_StokMaliyet(T.[StokKod],'',@magaza_no,GETDATE(),@maliyet_vergi_dahil)))/ ISNULL(NULLIF(T.[SatisTutar],0),1))*100,2) AS [Kar MarJı (%)],
	ROUND(((T.[SatisTutar]-(T.[SatisMiktar]*dbo.fn_StokMaliyet(T.[StokKod],'',@magaza_no,GETDATE(),@maliyet_vergi_dahil)))),2) as [KarTutar]
FROM
(
SELECT 
	sto_kod as StokKod,
	sto_isim as StokIsim,
	SUM(CASE 
			WHEN evr_belge_tur in (1,2) THEN har_miktar  
			WHEN evr_belge_tur=3 THEN (-1)*har_miktar ELSE 0 END) as SatisMiktar,
	SUM(CASE WHEN evr_belge_tur in (1,2) THEN har_yekun
			WHEN evr_belge_tur=3 THEN (-1)*har_yekun ELSE 0 END) as SatisTutar
FROM EVRAK_HAREKET_BILGI WITH(NOLOCK)
LEFT OUTER JOIN STOKLAR WITH(NOLOCK) ON sto_kod=har_stok_kodu
LEFT OUTER JOIN STOK_ANAGRUPLARI WITH(NOLOCK) ON san_kodu=sto_ana_grup_kodu
INNER JOIN EVRAK_UST_BILGI WITH(NOLOCK) ON har_evrak_rec_id=evr_RECno
WHERE  har_Satir_tip=0 AND
evr_belge_tur in (1,2,3) AND
CONVERT(DATE,@baslangic_tarih)<=CONVERT(DATE,evr_evrak_tarih) AND CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@bitis_tarih) 
AND (((select COUNT(Item) from @anagrup_kod_liste)>0 AND sto_ana_grup_kodu IN (select Item from @anagrup_kod_liste)) OR (select COUNT(Item) from @anagrup_kod_liste)=0)
AND (((select COUNT(Item) from @altgrup_kod_liste)>0 AND sto_alt_grup_kodu IN (select Item from @altgrup_kod_liste)) OR (select COUNT(Item) from @altgrup_kod_liste)=0)
AND (((select COUNT(Item) from @reyon_kod_liste)>0 AND sto_reyon_kodu IN (select Item from @reyon_kod_liste)) OR (select COUNT(Item) from @reyon_kod_liste)=0)
AND (sto_kod in (SELECT Item FROM @stok_kod_liste) OR (select Count(Item) from @stok_kod_liste)<=0)
AND evr_magaza_kod=@magaza_no
AND (evr_magaza_kod=dbo.fn_AktifKullaniciMagazaGetir(@aktif_kullanici) OR @aktif_kullanici=0)
GROUP BY sto_kod,sto_isim
)T
WHERE [SatisMiktar]>0