﻿$1    PROCEDURE [dbo].[SMARTCARD_HAREKET]
--@cari_kod StringList READONLY,
@baslangic_tarih dateTime,
@bitis_tarih datetime,
@cari_kod varchar(25)
AS
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
SELECT 
	cari_kodu as [Cari Kod],
	cari_unvan1+' '+cari_unvan2 as [Cari Unvan],
	CAST(evr_evrak_tarih AS DATE) as [Tarih], 
	CASE WHEN evr_belge_no_seri='HK' AND evr_belge_tur=6 THEN  dbo.fn_EvrakIsmi(evr_belge_tur)+' '+'BAKİYE YÜKLEME' ELSE dbo.fn_EvrakIsmi(evr_belge_tur) END as [İşlem],
	ISNULL((CASE WHEN evr_belge_tur=6 THEN (SELECT sum(odmhar_tutar) FROM EVRAK_ODEME_BILGI WHERE odmhar_evrak_rec_id=evr_RECno) ELSE -1*(SELECT sum(odmhar_tutar) FROM EVRAK_ODEME_BILGI WHERE odmhar_evrak_rec_id=evr_RECno) END),0) AS [İşlem Tutarı]
FROM EVRAK_UST_BILGI  WITH(NOLOCK)
INNER JOIN CARI_HESAPLAR WITH(NOLOCK) ON cari_kodu=evr_cari_kod
WHERE evr_cari_kod=@cari_kod AND cast(evr_evrak_tarih as date)>=@baslangic_tarih and cast(evr_evrak_tarih as date)<=@bitis_tarih
GROUP BY cari_kodu,cari_unvan1,cari_unvan2,evr_evrak_tarih,evr_belge_no_seri,evr_belge_no_sira,evr_belge_tur,evr_RECno
order by evr_evrak_tarih


