﻿$1     PROCEDURE [dbo].[SMART_CARD_HAREKET_FOY]
@baslangic_tarih dateTime,
@bitis_tarih datetime,
@kod varchar(50)
AS
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
SELECT 
	cari_kodu as [Cari Kod],
	cari_unvan1+' '+cari_unvan2 as [Cari Unvan],
	CAST(evr_evrak_tarih AS DATE) as [Tarih], 
	CASE WHEN evr_belge_no_seri='HK' AND evr_belge_tur=6 THEN  'BAKİYE YÜKLEME' WHEN evr_belge_no_seri='HKTD' AND evr_belge_tur=7 THEN 'BAKİYE İADE' ELSE dbo.fn_EvrakIsmi(evr_belge_tur) END as [İşlem],
	ISNULL(( SELECT top 1 odm_aciklama FROM  EVRAK_ODEME_BILGI INNER JOIN ODEME_TIPLERI ON EVRAK_ODEME_BILGI.odmhar_odeme_kod = ODEME_TIPLERI.odm_kod WHERE odmhar_evrak_rec_id=evr_RECno),'') AS [Ödeme Tipi],
	ISNULL((CASE WHEN evr_belge_tur=6 THEN (SELECT sum(odmhar_tutar) FROM EVRAK_ODEME_BILGI WHERE odmhar_evrak_rec_id=evr_RECno) ELSE -1*(SELECT sum(odmhar_tutar) FROM EVRAK_ODEME_BILGI WHERE odmhar_evrak_rec_id=evr_RECno) END),0) AS [İşlem Tutarı]
FROM EVRAK_UST_BILGI WITH(NOLOCK)
INNER JOIN CARI_HESAPLAR WITH(NOLOCK) ON cari_kodu=evr_cari_kod
WHERE (evr_cari_kod=@kod or @kod='') AND cast(evr_evrak_tarih as date)>=@baslangic_tarih and cast(evr_evrak_tarih as date)<=@bitis_tarih and evr_belge_no_seri='HK' or evr_belge_no_seri='HKTD'
GROUP BY evr_GuidNo,cari_kodu,cari_unvan1,cari_unvan2,evr_evrak_tarih,evr_belge_no_seri,evr_belge_no_sira,evr_belge_tur,evr_RECno 
order by evr_evrak_tarih

