﻿$1    PROCEDURE [dbo].[STOK_DEGER]
@magaza_no varchar(25),
@fiyat_no int=1,
@anagrup_kod_liste StringList READONLY,
@altgrup_kod_liste StringList READONLY,
@reyon_kod_liste StringList READONLY,
@stok_kod_liste StringList READONLY,
@maliyet_vergi_dahil bit
AS
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
SELECT
	*,
	T.[DepodakiMiktar]*T.[SonAlisFiyati] AS AlisFiyatiToplamDegeri,
	T.[DepodakiMiktar]*T.[SatisFiyati] AS SatisFiyatiToplamDegeri,
	ROUND(((T.[SatisFiyati]-T.[SonAlisFiyati])/ISNULL(NULLIF(T.[SatisFiyati],0),1))*100,2) AS [Kar Marjı (%)]
FROM(
SELECT
sto_kod as StokKod,
sto_isim as StokIsim,
bar_barkodu FiyatlamadaBazAlinanBarkod,
MAX(dbo.fn_DepoMiktar(sto_kod,@magaza_no,GETDATE())) AS DepodakiMiktar,--GRUPLAMAK İÇİN MAX YAPILDI
MAX(dbo.fn_StokMaliyet('',bar_barkodu,@magaza_no,GETDATE(),@maliyet_vergi_dahil)) as SonAlisFiyati,
CASE 
	WHEN @fiyat_no=1 THEN bar_birim_fiyat1
	WHEN @fiyat_no=2 THEN bar_birim_fiyat2
	WHEN @fiyat_no=3 THEN bar_birim_fiyat3
	WHEN @fiyat_no=4 THEN bar_birim_fiyat4
	WHEN @fiyat_no=5 THEN bar_birim_fiyat5 
	ELSE bar_birim_fiyat1
	end AS SatisFiyati
FROM STOKLAR WITH(NOLOCK)
LEFT OUTER JOIN STOK_BARKOD_TANIMLARI WITH(NOLOCK) ON bar_stokkodu=sto_kod and bar_GuidNo=(SELECT TOP 1 bar_GuidNo FROM STOK_BARKOD_TANIMLARI WITH(NOLOCK) WHERE bar_stokkodu=sto_kod AND bar_depono=@magaza_no Order by bar_birim_katsayi)
WHERE bar_depono=@magaza_no AND
	(sto_ana_grup_kodu in (SELECT Item FROM @anagrup_kod_liste) OR (select Count(Item) from @anagrup_kod_liste)<=0)
	AND (sto_alt_grup_kodu in (SELECT Item FROM @altgrup_kod_liste) OR (select Count(Item) from @altgrup_kod_liste)<=0)
	AND (sto_reyon_kodu in (SELECT Item FROM @reyon_kod_liste) OR (select Count(Item) from @reyon_kod_liste)<=0)
	AND (sto_kod in (SELECT Item FROM @stok_kod_liste) OR (select Count(Item) from @stok_kod_liste)<=0)
GROUP BY sto_kod,sto_isim,bar_barkodu,bar_birim_fiyat1,bar_birim_fiyat2,bar_birim_fiyat3,bar_birim_fiyat4,bar_birim_fiyat5
)T
WHERE T.[DepodakiMiktar]>0 

