﻿$1   PROCEDURE [dbo].[STOK_DETAYLI_SATIS]
@aktif_kullanici varchar(25)='',
@magaza_no_liste StringList READONLY,
@baslangic_tarih dateTime,
@bitis_tarih datetime,
@stok_kod_liste StringList READONLY
AS
-- ==========================================================================================
-- Evrak Tipleri:	--1:FİŞ 2:SATIŞ FAT 3:İADE 4:FİŞ IPTAL  5:ALIŞ FATURASI 
--			          6:TAHSİLAT MAKBUZU 7:TEDIYE MAKBUZU 8:FATURA IPTAL 9:DEPO SEVK 10:ALIŞ IADE 
--				     11:CARI BORÇ DEKONTU 12:SAYIM EVRAĞI 13:DEPO GİRİŞ 14:DEPO ÇIKIŞ
-- ==========================================================================================
SELECT
*,
T.[SatisMiktar]-T.[IadeMiktar] AS NetMiktar,
T.[SatisTutar]-T.[IadeTutar] AS NetTutar
FROM
(SELECT
	sto_kod StokKod,
	sto_isim StokIsim,
	SUM(CASE WHEN evr_belge_tur =3 THEN har_miktar ELSE 0 END) as IadeMiktar,
	SUM(CASE WHEN evr_belge_tur =3 THEN har_yekun ELSE 0 END) as IadeTutar,
	SUM(CASE WHEN evr_belge_tur in (1,2) THEN har_miktar ELSE 0 END) as SatisMiktar,
	SUM(CASE WHEN evr_belge_tur in (1,2) THEN har_yekun ELSE 0 END) as SatisTutar
FROM EVRAK_HAREKET_BILGI WITH(NOLOCK)
LEFT OUTER JOIN STOKLAR WITH(NOLOCK) ON har_stok_kodu=sto_kod
INNER JOIN EVRAK_UST_BILGI WITH(NOLOCK) ON har_evrak_rec_id=evr_RECno
WHERE  evr_belge_tur in (1,2,3) and  (((select COUNT(Item) from @magaza_no_liste)>0 AND evr_magaza_kod IN (select Item from @magaza_no_liste)) OR (select Count(Item) from @magaza_no_liste)<=0) AND  
		CONVERT(DATE,@baslangic_tarih)<=CONVERT(DATE,evr_evrak_tarih) and CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@bitis_tarih) and har_Satir_tip=0
		AND (sto_kod in (SELECT Item FROM @stok_kod_liste) OR (select Count(Item) from @stok_kod_liste)<=0)
		AND (evr_magaza_kod=dbo.fn_AktifKullaniciMagazaGetir(@aktif_kullanici) OR @aktif_kullanici=0)
GROUP BY sto_kod,sto_isim)T