﻿$1  PROCEDURE [dbo].[STOK_FIYAT_DEGISIKLERI]
@baslangic_tarih datetime,
@bitis_tarih datetime,
@magaza_no varchar(25)=''
AS
SELECT
	fd_seri+'-'+cast(fd_sira as varchar(25)) as [Evrak No],
	fd_create_date as [Evrak Tarih],
	fd_belgeNo as [Belge No],
	fd_barkod as [Barkod],
	sto_isim as [Stok İsim],
	fd_depoKod as [Depo No],
	fd_degisiklikTarihi as [Tarih],
	fd_eskiFiyat1 as [Eski Fiyat],
	fd_yeniFiyat1 as [Yeni Fiyat],
	CASE WHEN fd_degisiklikUygulandi=1 THEN 'Evet' Else 'Hayır' End as [Yapıldı Mı?],
	ROUND(((fd_yeniFiyat1-fd_eskiFiyat1)/isnull(nullif(fd_eskiFiyat1,0),1))*100,2)  [Değişim %],
	fd_yeniFiyat1-fd_eskiFiyat1 [Fark],
	fd_yeniFiyat1 as [Aktif Fiyat]
FROM FIYAT_DEGISIKLIKLERI WITH(NOLOCK)
LEFT OUTER JOIN STOK_BARKOD_TANIMLARI WITH(NOLOCK) ON bar_barkodu=fd_barkod AND bar_depono=fd_depoKod
LEFT OUTER JOIN STOKLAR WITH(NOLOCK) ON sto_kod=bar_stokkodu
WHERE CAST(fd_degisiklikTarihi as date)>=CAST(@baslangic_tarih as date) AND CAST(fd_degisiklikTarihi as date)<=CAST(@bitis_tarih as date)
AND (fd_depoKod=CAST(@magaza_no as int) or @magaza_no='')
