﻿$1   PROCEDURE [dbo].[STOK_HAREKET_FOY]
@baslangic_tarih dateTime,
@bitis_tarih datetime,
@kod varchar(50),
@magaza_no_liste StringList READONLY
AS
(SELECT
evr_GuidNo,
evr_evrak_tarih as [Tarih],
evr_belge_no_seri as [Seri],
evr_belge_no_sira as [Sıra],
dbo.fn_EvrakIsmi(evr_belge_tur) as [Evrak Tipi],
(SELECT TOP 1 mgz_isim FROM MAGAZA_TANIMLARI WITH(NOLOCK) WHERE mgz_kod=evr_magaza_kod) as Magaza,
(SELECT TOP 1 mgz_isim FROM MAGAZA_TANIMLARI WITH(NOLOCK) WHERE mgz_kod=evr_cikis_magaza_kod) as [Çıkış Magaza],
har_miktar as Miktar,
dbo.fn_EldekiMiktar(@kod) AS [Kalan Miktar],
bar_birim_ad as [Birim Adı],
ROUND(har_fiyat,2) as [Birim Fiyat],
ROUND(har_yekun,2) as [Yekun],
evr_fis_no as [Fiş No],
ksa_isim as [Kasa],
mgz_isim as [Mağaza],
(SELECT TOP 1 kln_isim FROM KULLANICILAR WITH(NOLOCK) WHERE kln_no=evr_kasiyer_no) as [Kasiyer],
(SELECT TOP 1 kln_isim FROM KULLANICILAR WITH(NOLOCK) WHERE kln_no=evr_plasiyer_no) as [Plasiyer]
FROM EVRAK_HAREKET_BILGI  f WITH(NOLOCK)
LEFT OUTER JOIN EVRAK_UST_BILGI WITH(NOLOCK) ON evr_RECno=har_evrak_rec_id
LEFT OUTER JOIN STOK_BARKOD_TANIMLARI WITH(NOLOCK) ON har_barkod=bar_barkodu and evr_magaza_kod=bar_depono
LEFT OUTER JOIN KASA_TANIMLARI WITH(NOLOCK) ON evr_kasa_no=ksa_no
LEFT OUTER JOIN MAGAZA_TANIMLARI WITH(NOLOCK) ON mgz_kod=evr_magaza_kod
WHERE CONVERT(DATE,@baslangic_tarih)<=CONVERT(DATE,evr_evrak_tarih) and CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@bitis_tarih) 
AND ((((select COUNT(Item) from @magaza_no_liste)>0 AND evr_magaza_kod IN (select Item from @magaza_no_liste)) OR (select Count(Item) from @magaza_no_liste)<=0) 
OR (((select COUNT(Item) from @magaza_no_liste)>0 AND evr_cikis_magaza_kod IN (select Item from @magaza_no_liste)) OR (select Count(Item) from @magaza_no_liste)<=0) )
AND har_stok_kodu=@kod AND har_satir_tip=0
)
UNION ALL
(
SELECT
NEWID() as evr_GuidNo,
@baslangic_tarih as [Tarih],
'' as [Seri],
0 as [Sıra],
'DEVIR' as[Evrak Tipi],
'' Magaza,
'' [Çıkış Magaza],
SUM(har_miktar) as Miktar,
dbo.fn_EldekiMiktar(@kod) AS [Kalan Miktar],
'' as [Birim Adı],
SUM(har_fiyat) as [Birim Fiyat],
sum(har_yekun) as [Yekun],
0 as [Fiş No],
'' as [Kasa],
'' as [Mağaza],
'' [Kasiyer],
'' [Plasiyer]
FROM EVRAK_HAREKET_BILGI f
LEFT OUTER JOIN EVRAK_UST_BILGI ON evr_RECno=har_evrak_rec_id
WHERE har_stok_kodu=@kod AND CONVERT(DATE,evr_evrak_tarih)<=CONVERT(DATE,@baslangic_tarih)
GROUP BY har_stok_kodu
)
ORDER BY [Tarih]