﻿$1   PROCEDURE [dbo].[STOK_MIKTAR]
@anagrup_kod_liste StringList READONLY,
@altgrup_kod_liste StringList READONLY,
@reyon_kod_liste StringList READONLY,
@stok_kod_liste StringList READONLY,
@magaza_no_liste  StringList READONLY
AS
DECLARE @sorgu AS NVARCHAR(MAX)=''
DECLARE @kosul AS NVARCHAR(MAX)=''
DECLARE @magazlar  AS NVARCHAR(MAX)=''
DECLARE @anaGruplar  AS NVARCHAR(MAX)=''
DECLARE @altGruplar AS NVARCHAR(MAX)=''
DECLARE @reyonlar  AS NVARCHAR(MAX)=''
DECLARE @stoklar AS NVARCHAR(MAX)=''

SET @magazlar = STUFF((SELECT distinct ',' + QUOTENAME(c.mgz_kod+'-'+c.mgz_isim) 
            FROM MAGAZA_TANIMLARI c WITH(NOLOCK)
			WHERE (mgz_kod in (SELECT Item FROM @magaza_no_liste ) or (SELECT COUNT(Item) FROM @magaza_no_liste )=0)
			GROUP BY mgz_kod+'-'+mgz_isim
            FOR XML PATH(''), TYPE
            ).value('.', 'NVARCHAR(MAX)') 
        ,1,1,'')

SET @anaGruplar=  STUFF((
            SELECT ',''' + c.Item+''''
            FROM @anagrup_kod_liste c
            FOR XML PATH('')
            ), 1, 1, '')

SET @altGruplar=  STUFF((
            SELECT ',''' + c.Item+''''
            FROM @altgrup_kod_liste c
            FOR XML PATH('')
            ), 1, 1, '')

SET @reyonlar=  STUFF((
            SELECT ',''' + c.Item+''''
            FROM @reyon_kod_liste c
            FOR XML PATH('')
            ), 1, 1, '')

SET @stoklar=  STUFF((
            SELECT ',''' + c.Item+''''
            FROM @stok_kod_liste c
            FOR XML PATH('')
            ), 1, 1, '')

IF(@anaGruplar!='')
	SET @kosul='sto_ana_grup_kodu in ('+@anaGruplar+')'
IF(@altGruplar!='')
	SET @kosul+=CASE WHEN @kosul!='' THEN ' AND ' ELSE '' END + 'sto_alt_grup_kodu in ('+@altGruplar+')'
IF(@reyonlar!='')
	SET @kosul+=CASE WHEN @kosul!='' THEN ' AND ' ELSE '' END + 'sto_reyon_kodu in ('+@reyonlar+')'
IF(@stoklar!='')
	SET @kosul+=CASE WHEN @kosul!='' THEN ' AND ' ELSE '' END + 'sto_kod in ('+@stoklar+')'


IF(@kosul='')
	SET @kosul+=CASE WHEN @kosul='' THEN ' 1=1 ' END 

SET @sorgu=N'
SELECT *
FROM(
SELECT
mgz_kod+''-''+mgz_isim as Magaza,
sto_kod as [StokKod],
sto_isim as [StokIsim],
dbo.fn_AnaGrupIsim(sto_ana_grup_kodu) as [AnaGrupIsim],
dbo.fn_AltGrupIsim(sto_ana_grup_kodu,sto_alt_grup_kodu) as [AltGrupIsim],
dbo.fn_ReyonIsim(sto_reyon_kodu) as [Reyon İsim],
dbo.fn_DepoMiktar(sto_kod,mgz_kod,GETDATE()) as Miktar,
dbo.fn_EldekiMiktar(sto_kod) as [Eldeki Miktar]
FROM STOKLAR WITH(NOLOCK),MAGAZA_TANIMLARI WITH(NOLOCK)
WHERE '+@kosul+'
)as stokDepo
PIVOT
(sum(Miktar)
FOR Magaza IN ('+@magazlar+')
)AS pvt'
execute (@sorgu)